package org.jresearch.commons.gwt.oauth2.client.service.oauth2;

import java.util.List;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.service.NoUserException;
import org.jresearch.commons.gwt.oauth2.client.model.OauthConfiguration;
import org.jresearch.commons.gwt.oauth2.client.model.SocialNetwork;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("oauth2Service.gwt")
public interface IOauth2Service extends RemoteService {

	String ID = "OAuth2Service_SERVICE"; //$NON-NLS-1$

	/**
	 * Returns the OAuth2 configuration for selected social network (or any
	 * other OAuth 2.0 provider)
	 * 
	 * @param network
	 * @return the preconfigured settings or <code>null</code> if selected OAuth
	 *         2.0 provider (e.g social network) is not configured
	 */
	OauthConfiguration getServiceConfiguration(@Nonnull SocialNetwork network);

	/**
	 * Returns the OAuth2 configurations for all supported social networks (or
	 * any other OAuth 2.0 provider)
	 * 
	 * @return the preconfigured settings for OAuth 2.0 providers (e.g social
	 *         network)
	 */
	List<OauthConfiguration> getServiceConfigurations();

	/**
	 * Associate the social netvork with current user
	 * 
	 * @param network
	 * @param authenticationToken
	 * @throws NoUserException
	 */
	void associateWithCurrentUser(@Nonnull SocialNetwork network, @Nonnull String authenticationToken) throws NoUserException;

}