package org.jresearch.commons.gwt.oauth2.client.service;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

import org.fusesource.restygwt.client.DirectRestService;
import org.jresearch.commons.gwt.oauth2.shared.model.OauthConfiguration;
import org.jresearch.commons.gwt.oauth2.shared.model.SocialNetwork;
import org.jresearch.commons.gwt.oauth2.shared.service.oauth2.Oauth2Service;

public interface Oauth2RestService extends Oauth2Service, DirectRestService {

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_R_CONF_NET)
	@Override
	OauthConfiguration getServiceConfiguration(SocialNetwork network);

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_R_CONFS)
	@Override
	List<OauthConfiguration> getServiceConfigurations();

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_SET_USER)
	@Override
	void associateWithCurrentUser(@PathParam("net") SocialNetwork network, String authenticationToken);

}
