package org.jresearch.commons.gwt.shared.model.localization;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

public class L18nSorter implements Comparator<LocaleModel> {

	private final List<LocaleModel> top = new ArrayList<>();

	public void addTopLocale(@Nonnull final LocaleModel language) {
		if (top.contains(language)) {
			top.remove(language);
		}
		top.add(0, language);
	}

	@Override
	/*
	 * * m1 > m2 => 1 m1 < m2 => -1 m1 = m2 = 0
	 */
	public int compare(final LocaleModel m1, final LocaleModel m2) {
		final int m1Index = top.indexOf(m1);
		final int m2Index = top.indexOf(m2);
		if (m1Index != -1 && m2Index != -1) {
			return m1Index - m2Index;
		} else if (m1Index != -1) {
			return -1;
		} else if (m2Index != -1) {
			return 1;
		}
		return m1.getLanguage().compareTo(m2.getLanguage());
	}

}
