package org.jresearch.commons.gwt.shared.model.localization;

import java.io.Serializable;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class LangModel implements Serializable {

	private static final long serialVersionUID = -570554202487821588L;

	private LocaleModel locale;
	private String value;

	/**
	 * @return the locale
	 */
	public LocaleModel getLocale() {
		return locale;
	}

	/**
	 * @param locale
	 *            the locale to set
	 */
	public void setLocale(final LocaleModel locale) {
		this.locale = locale;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(final String value) {
		this.value = value;
	}

	@SuppressWarnings("nls")
	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this)
				.add("locale", locale)
				.add("value", value)
				.toString();
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(getLocale(), getValue());
	}

	@Override
	public boolean equals(final Object object) {
		if (object instanceof LangModel) {
			final LangModel that = (LangModel) object;
			return Objects.equal(this.getLocale(), that.getLocale())
					&& Objects.equal(this.getValue(), that.getValue());
		}
		return false;
	}

}
