package org.jresearch.commons.gwt.shared.model.ref;

import org.jresearch.commons.gwt.shared.model.localization.L18nDomainModel;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class DictionaryEntityModel extends L18nDomainModel<String> {

	private static final long serialVersionUID = -9150425778882860105L;

	private String code;

	@Override
	public String getId() {
		return code;
	}

	/**
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * @param code
	 *            the code to set
	 */
	public void setCode(final String code) {
		this.code = code;
	}

	@SuppressWarnings("nls")
	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this)
				.add("super", super.toString())
				.add("code", code)
				.toString();
	}

	@SuppressWarnings("boxing")
	@Override
	public int hashCode() {
		return Objects.hashCode(super.hashCode(), getCode());
	}

	@Override
	public boolean equals(final Object object) {
		if (object instanceof DictionaryEntityModel) {
			if (!super.equals(object)) {
				return false;
			}
			final DictionaryEntityModel that = (DictionaryEntityModel) object;
			return Objects.equal(this.getCode(), that.getCode());
		}
		return false;
	}

}
