package org.jresearch.commons.gwt.client.model;

import java.util.function.Function;

import javax.annotation.Nonnull;

public class GwtValueProvider<S, T> implements ValueProvider<S, T> {

	@Nonnull
	private final String path;
	@Nonnull
	private final Function<S, T> valueFunction;

	public GwtValueProvider(@Nonnull final String path, @Nonnull final Function<S, T> valueFunction) {
		this.path = path;
		this.valueFunction = valueFunction;
	}

	@Override
	public String getPath() {
		return path;
	}

	@Override
	public T getValue(final S source) {
		return valueFunction.apply(source);
	}
}
