package org.jresearch.commons.gwt.client.widget.colorpicker;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Original code was taken from
 * http://www.subshell.com/en/subshell/blog/Implementing-a-Color-Picker-Dialog-
 * With-Canvas-and-GWT100.html
 *
 * @author http://www.subshell.com/en/subshell/blog/Implementing-a-Color-Picker-Dialog-
 *         With-Canvas-and-GWT100.html
 *
 * @author kot
 */
public class ColorChangedEvent extends GwtEvent<IColorChangedHandler> {

    public static final GwtEvent.Type<IColorChangedHandler> TYPE = new Type<>();

    private final String color;

    ColorChangedEvent(final String color) {
        this.color = color;
    }

    @Override
    public GwtEvent.Type<IColorChangedHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(final IColorChangedHandler handler) {
        handler.colorChanged(this);
    }

    public String getColor() {
        return color;
    }
}
