package org.jresearch.commons.gwt.client.widget.colorpicker;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Original code was taken from
 * http://www.subshell.com/en/subshell/blog/Implementing-a-Color-Picker-Dialog-
 * With-Canvas-and-GWT100.html
 *
 * @author http://www.subshell.com/en/subshell/blog/Implementing-a-Color-Picker-Dialog-
 *         With-Canvas-and-GWT100.html
 *
 * @author kot
 */
public class HueChangedEvent extends GwtEvent<IHueChangedHandler> {

    public static final GwtEvent.Type<IHueChangedHandler> TYPE = new Type<>();

    private final int hue;

    HueChangedEvent(final int hue) {
        this.hue = hue;
    }

    @Override
    public GwtEvent.Type<IHueChangedHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(final IHueChangedHandler handler) {
        handler.hueChanged(this);
    }

    public int getHue() {
        return hue;
    }
}
