package org.jresearch.commons.gwt.client.widget;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.util.resource.UtilRs;

import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Event.NativePreviewEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;

public class InfoBox extends DialogBox {

    @Nonnull
    private static final SafeHtml cancelButton = UtilRs.TXT.cancelButton();

    @Nonnull
    private Label content;
    private Button cancel;
    @Nonnull
    private ButtonPanel panel;

    public InfoBox(@Nonnull final SafeHtml title, @Nonnull final SafeHtml text, @Nonnull final Action... actions) {
        this(actions);
        setHTML(title);
        content.setText(text.asString());
    }

    public InfoBox(@Nonnull final Action... actions) {
        final FlowPanel main = new FlowPanel();
        setModal(true);
        main.add(content = new Label());
        main.add(panel = createActionButtons(actions));
        setWidget(main);
        setGlassEnabled(true);
    }

    @Nonnull
    protected ButtonPanel createActionButtons(@Nonnull final Action... actions) {
        final ButtonPanel actionBar = new ButtonPanel();
        createButtons(actionBar, actions);
        return actionBar;
    }

    protected void createButtons(@Nonnull final ButtonPanel p, @Nonnull final Action... actions) {
        p.clear();
        for (final Action action : actions) {
            p.add(createButton(action));
        }
        if (cancel == null) {
            cancel = createButton(new Action(cancelButton, this::close));
        }
        p.add(cancel);
    }

    protected Button createButton(final Action action) {
        return new Button(action.getActionName(), e -> close(action.getHandler()));
    }

    private void close(final Command toDo) {
        hide(false);
        toDo.execute();
    }

    public void show(@Nonnull final Action... actions) {
        createButtons(panel, actions);
        center();
    }

    public void show(@Nonnull final SafeHtml title, @Nonnull final SafeHtml text, @Nonnull final Action... actions) {
        createButtons(panel, actions);
        show(title, text);
    }

    public void show(@Nonnull final SafeHtml title, @Nonnull final SafeHtml text) {
        setHTML(title);
        content.setText(text.asString());
        center();
    }

    private void close() {
        hide(true);
    }

    @Override
    protected void onPreviewNativeEvent(final NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        if (Event.ONKEYDOWN == event.getTypeInt() && event.getNativeEvent().getKeyCode() == KeyCodes.KEY_ESCAPE) {
            close();
        }
    }

}
