package org.jresearch.commons.gwt.client.model.l18n;

import java.util.ArrayList;
import java.util.Collections;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.widget.DynamicList;
import org.jresearch.commons.gwt.shared.model.localization.L18nSorter;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class L18nDynamicList extends DynamicList<LocaleModel> {

	private L18nSorter sorter;

	@Inject
	public L18nDynamicList(@Nonnull final Bus bus) {
		super(bus);
	}

	public void addTopLocale(@Nonnull final LocaleModel item) {
		sorter.addTopLocale(item);
		final ArrayList<LocaleModel> toSort = new ArrayList<>(getValues());
		Collections.sort(toSort, sorter);
		update(toSort);
	}

}
