package org.jresearch.commons.gwt.client.widget;

import javax.annotation.Nonnull;

import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.Command;

public class ConfirmationBox extends MessageBox {

    @Nonnull
    private final SafeHtml action;

    public ConfirmationBox(@Nonnull final SafeHtml title, @Nonnull final SafeHtml text, @Nonnull final SafeHtml action) {
        super(title, text);
        this.action = action;
    }

    public ConfirmationBox(@Nonnull final SafeHtml action) {
        super();
        this.action = action;
    }

    public void show(@Nonnull final SafeHtml title, @Nonnull final SafeHtml text, @Nonnull final Command command) {
        super.show(title, text, new Action(action, command));
    }

    public void show(@Nonnull final Command command) {
        super.show(new Action(action, command));
    }

}
