package org.jresearch.commons.gwt.client.widget;

import java.util.Iterator;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.Widget;

public class ButtonPanel extends FlowPanel implements HasEnabled {

	private static final String STYLE = "buttonPanel"; //$NON-NLS-1$

	private boolean enabled;

	public ButtonPanel() {
		setStyleName(STYLE);
	}

	public void disable() {
		setEnabled(false);
	}

	public void enable() {
		setEnabled(true);
	}

	@Override
	public void setEnabled(final boolean enabled) {
		this.enabled = enabled;
		final Iterator<Widget> iterator = iterator();
		while (iterator.hasNext()) {
			final Widget widget = iterator.next();
			if (widget instanceof HasEnabled) {
				final HasEnabled hasEnabled = (HasEnabled) widget;
				hasEnabled.setEnabled(enabled);
			}
		}
	}

	@Override
	public boolean isEnabled() {
		return enabled;
	}

}
