package org.jresearch.commons.gwt.client.widget;

import org.jresearch.commons.gwt.client.model.l18n.L18nDynamicList;
import org.jresearch.commons.gwt.client.model.l18n.L18nRenderer;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.inject.Inject;

public class SimpleL18nComboBox extends ExChosenValueListBox<LocaleModel> {

	@Inject
	public SimpleL18nComboBox(final ChosenListBoxBinding<LocaleModel> binding, final L18nRenderer renderer) {
		super(binding, renderer);
		addValueChangeHandler(new ValueChangeHandler<LocaleModel>() {
			@Override
			public void onValueChange(final ValueChangeEvent<LocaleModel> event) {
				final LocaleModel item = event.getValue();
				if (item != null) {
					final DynamicList<? extends LocaleModel> list = binding.getList();
					if (list instanceof L18nDynamicList) {
						((L18nDynamicList) list).addTopLocale(item);
					}
				}
			}
		});
	}

}
