package org.jresearch.commons.gwt.client.widget;

import java.util.ArrayList;
import java.util.List;

import com.arcbees.chosen.client.ChosenOptions;
import com.arcbees.chosen.client.event.ChosenChangeEvent.ChosenChangeHandler;
import com.arcbees.chosen.client.event.HasChosenChangeHandlers;
import com.arcbees.chosen.client.event.HasHidingDropDownHandlers;
import com.arcbees.chosen.client.event.HidingDropDownEvent.HidingDropDownHandler;
import com.arcbees.chosen.client.gwt.ChosenValueListBox;
import com.google.common.collect.ImmutableList;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.view.client.ProvidesKey;
import com.google.web.bindery.event.shared.HandlerRegistration;

public class ExChosenValueListBox<M> extends ChosenValueListBox<M>implements HasChosenChangeHandlers, HasHidingDropDownHandlers {

    private final ChosenListBoxBinding<M> binding;

    public ExChosenValueListBox(final ChosenListBoxBinding<M> binding, final Renderer<M> renderer) {
        super(renderer);
        this.binding = binding;
        binding.bind(this);
    }

    public ExChosenValueListBox(final ChosenListBoxBinding<M> binding, final Renderer<M> renderer, final ChosenOptions options) {
        super(renderer, options);
        this.binding = binding;
        binding.bind(this);
    }

    public ExChosenValueListBox(final ChosenListBoxBinding<M> binding, final Renderer<M> renderer, final ProvidesKey<M> keyProvider) {
        super(renderer, keyProvider);
        this.binding = binding;
        binding.bind(this);
    }

    public ExChosenValueListBox(final ChosenListBoxBinding<M> binding, final Renderer<M> renderer, final ProvidesKey<M> keyProvider, final ChosenOptions options) {
        super(renderer, keyProvider, options);
        this.binding = binding;
        binding.bind(this);
    }

    @Override
    public HandlerRegistration addChosenChangeHandler(final ChosenChangeHandler handler) {
        return getChosenListBox().addChosenChangeHandler(handler);
    }

    @Override
    public HandlerRegistration addHidingDropDownHandler(final HidingDropDownHandler handler) {
        return getChosenListBox().addHidingDropDownHandler(handler);
    }

    public int getSelectedIndex() {
        return getChosenListBox().getSelectedIndex();
    }

    public void setSelectedIndex(final int index) {
        if (getChosenListBox().getItemCount() >= index) {
            getChosenListBox().setSelectedIndex(index);
        }
    }

    @Override
    public void setValue(final M newValue) {
        if (isAccepted(newValue)) {
            super.setValue(newValue);
        } else {
            binding.setValue(newValue);
        }
    }

    @Override
    public M getValue() {
        final M value = super.getValue();
        return value == null ? binding.getValue() : value;
    }

    public List<M> getAcceptableValues() {
        return values == null ? ImmutableList.<M> of() : new ArrayList<>(values);
    }

}
