package org.jresearch.commons.gwt.client.service;

import java.util.Collection;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;

import org.fusesource.restygwt.client.DirectRestService;
import org.jresearch.commons.gwt.shared.loader.PageCrudLoadConfig;
import org.jresearch.commons.gwt.shared.loader.PageLoadResult;
import org.jresearch.commons.gwt.shared.model.ref.BusinessTypeModel;
import org.jresearch.commons.gwt.shared.service.ref.RefService;

public interface RefRestService extends RefService, DirectRestService {

	@DELETE
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_D)
	@Override
	void remove(Collection<BusinessTypeModel> model);

	@PUT
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_C)
	@Override
	BusinessTypeModel create(BusinessTypeModel prototype);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_U)
	@Override
	void update(BusinessTypeModel model);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_R)
	@Override
	PageLoadResult<BusinessTypeModel> getAll(PageCrudLoadConfig<BusinessTypeModel> config);

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_R_BY_CODE)
	@Override
	BusinessTypeModel getByCode(String code);

}
