package org.jresearch.commons.gwt.client.model.ref;

import java.util.EnumSet;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum BusinessTypeCodeModel {

    ADDR("ADDR"), //$NON-NLS-1$
    TEL("TEL"), //$NON-NLS-1$
    MOB("MOB"), //$NON-NLS-1$
    SERVICE_PROVIDER_ID("serviceProviderId"), //$NON-NLS-1$
    RESERVATION_UNIT_ID("RESERVATION_UNIT_ID"), //$NON-NLS-1$
    SALON_ADMINISTRATOR("SALON_ADMINISTRATOR"), //$NON-NLS-1$
    CITY("CITY"), //$NON-NLS-1$
    POSTAL_CODE("POSTAL_CODE"), //$NON-NLS-1$
    LATITUDE("LATITUDE"), //$NON-NLS-1$
    LONGITUDE("LONGITUDE"), //$NON-NLS-1$
    CURRENCY("CURRENCY"), //$NON-NLS-1$
    COUNTRY("COUNTRY"), //$NON-NLS-1$
    HOUSE_NUMBER("HOUSE_NUMBER");//$NON-NLS-1$

    @Nonnull
    private final String code;

    private BusinessTypeCodeModel(@Nonnull final String code) {
        this.code = code;
    }

    /**
     * @return the code
     */
    @Nonnull
    public String getCode() {
        return code;
    }

    @Nullable
    public static BusinessTypeCodeModel get(@Nonnull final String code) {
        final EnumSet<BusinessTypeCodeModel> all = EnumSet.allOf(BusinessTypeCodeModel.class);
        for (final BusinessTypeCodeModel model : all) {
            if (code.equals(model.getCode())) {
                return model;
            }
        }
        return null;
    }

}
