package org.jresearch.commons.gwt.client.model.ref;

import java.util.List;

import org.jresearch.commons.gwt.client.model.localization.L18nProperty;
import org.jresearch.commons.gwt.shared.tools.Strings;

public class BusinessTypeModel extends BaseReferenceModel {

	private static final long serialVersionUID = 746392433708529257L;

	private L18nProperty descriptions;
	private List<RefAttributeValueModel> validValues;
	private ParamTypeModel parameterType;
	private boolean mandatory;
	private Long minValue;
	private Long maxValue;
	private String regularExpression;
	private boolean userAttribute;
	private String code;

	@Override
	public String toString() {
		return Strings.format("Attribute type with name {0} and code {1}", getName(), getCode()); //$NON-NLS-1$
	}

	/**
	 * @return the validValues
	 */
	public List<RefAttributeValueModel> getValidValues() {
		return validValues;
	}

	/**
	 * @param validValues
	 *            the validValues to set
	 */
	public void setValidValues(final List<RefAttributeValueModel> validValues) {
		this.validValues = validValues;
	}

	/**
	 * @return the parameterType
	 */
	public ParamTypeModel getParameterType() {
		return parameterType;
	}

	/**
	 * @param parameterType
	 *            the parameterType to set
	 */
	public void setParameterType(final ParamTypeModel parameterType) {
		this.parameterType = parameterType;
	}

	/**
	 * @return the mandatory
	 */
	public boolean isMandatory() {
		return mandatory;
	}

	/**
	 * @param mandatory
	 *            the mandatory to set
	 */
	public void setMandatory(final boolean mandatory) {
		this.mandatory = mandatory;
	}

	/**
	 * @return the minValue
	 */
	public Long getMinValue() {
		return minValue;
	}

	/**
	 * @param minValue
	 *            the minValue to set
	 */
	public void setMinValue(final Long minValue) {
		this.minValue = minValue;
	}

	/**
	 * @return the maxValue
	 */
	public Long getMaxValue() {
		return maxValue;
	}

	/**
	 * @param maxValue
	 *            the maxValue to set
	 */
	public void setMaxValue(final Long maxValue) {
		this.maxValue = maxValue;
	}

	/**
	 * @return the regularExpression
	 */
	public String getRegularExpression() {
		return regularExpression;
	}

	/**
	 * @param regularExpression
	 *            the regularExpression to set
	 */
	public void setRegularExpression(final String regularExpression) {
		this.regularExpression = regularExpression;
	}

	/**
	 * @return the userAttribute
	 */
	public boolean isUserAttribute() {
		return userAttribute;
	}

	/**
	 * @param userAttribute
	 *            the userAttribute to set
	 */
	public void setUserAttribute(final boolean userAttribute) {
		this.userAttribute = userAttribute;
	}

	/**
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * @param code
	 *            the code to set
	 */
	public void setCode(final String code) {
		this.code = code;
	}

	/**
	 * @return the descriptions
	 */
	public L18nProperty getDescriptions() {
		return descriptions;
	}

	/**
	 * @param descriptions
	 *            the descriptions to set
	 */
	public void setDescriptions(final L18nProperty descriptions) {
		this.descriptions = descriptions;
	}

}
