package org.jresearch.commons.gwt.client.model.ref;

import org.jresearch.commons.gwt.client.model.localization.L18nDomainModel;
import org.jresearch.commons.gwt.shared.tools.Strings;

public class DictionaryEntityModel extends L18nDomainModel<String> {

	private static final long serialVersionUID = -9150425778882860105L;

	private String code;

	@Override
	public String getId() {
		return code;
	}

	/**
	 * @return the code
	 */
	public String getCode() {
		return code;
	}

	/**
	 * @param code
	 *            the code to set
	 */
	public void setCode(final String code) {
		this.code = code;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		if (getCode() == null) {
			return super.hashCode();
		}
		final int prime = 31;
		int result = 1;
		result = prime * result + ((getId() == null) ? 0 : getCode().hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final DictionaryEntityModel other = (DictionaryEntityModel) obj;
		if (getCode() == null) {
			if (other.getCode() != null) {
				return false;
			}
			return super.equals(obj);
		} else if (!getCode().equals(other.getCode())) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return Strings.format("Dictionary entity {0} with code {1}", getName(), getCode()); //$NON-NLS-1$
	}

}
