package org.jresearch.commons.gwt.client.widget.colorpicker;

import com.google.gwt.event.shared.GwtEvent;

/**
 * Original code was taken from
 * http://www.subshell.com/en/subshell/blog/Implementing-a-Color-Picker-Dialog-
 * With-Canvas-and-GWT100.html
 *
 * @author
 * http://www.subshell.com/en/subshell/blog/Implementing-a-Color-Picker-Dialog-
 * With-Canvas-and-GWT100.html
 *
 * @author kot
 */
public class HueChangedEvent extends GwtEvent<IHueChangedHandler> {
    private static GwtEvent.Type<IHueChangedHandler> TYPE;

    private final int hue;

    HueChangedEvent(final int hue) {
        this.hue = hue;
    }

    public static GwtEvent.Type<IHueChangedHandler> getType() {
        if (TYPE == null) {
            TYPE = new Type<>();
        }
        return TYPE;
    }

    @Override
    public GwtEvent.Type<IHueChangedHandler> getAssociatedType() {
        return TYPE;
    }

    @Override
    protected void dispatch(final IHueChangedHandler handler) {
        handler.hueChanged(this);
    }

    public int getHue() {
        return hue;
    }
}
