package org.jresearch.commons.gwt.client.widget;

import java.util.ArrayList;
import java.util.List;

import org.jresearch.commons.gwt.client.mvc.event.Bus;

import com.google.inject.Inject;

public class ChosenListBoxBinding<T> extends DynamicListBinding<T> {

	private ExChosenValueListBox<T> listBox;
	private T value;

	@Inject
	public ChosenListBoxBinding(final DynamicList<T> list, final Bus bus) {
		super(list, bus);
	}

	public void bind(@SuppressWarnings("hiding") final ExChosenValueListBox<T> listBox) {
		this.listBox = listBox;
		final List<? extends T> values = getValues();
		final List<T> elementsWithFirstNull = new ArrayList<>(values.size() + 1);
		elementsWithFirstNull.add(null);
		elementsWithFirstNull.addAll(values);
		this.listBox.setAcceptableValues(elementsWithFirstNull);
	}

	@Override
	public void update(final List<? extends T> values) {
		if (listBox != null) {
			final List<T> elementsWithFirstNull = new ArrayList<>(values.size() + 1);
			elementsWithFirstNull.add(null);
			elementsWithFirstNull.addAll(values);
			listBox.setAcceptableValues(elementsWithFirstNull);
			final int selectedIndex = listBox.getSelectedIndex();
			final boolean accepted = listBox.isAccepted(value);
			if (selectedIndex == 0 && value != null && accepted) {
				this.listBox.setValue(value);
			}
		}
	}

	public void setValue(final T value) {
		this.value = value;
	}

	/**
	 * @return the value
	 */
	public T getValue() {
		return value;
	}

	/**
	 * @return the listBox
	 */
	protected ExChosenValueListBox<T> getListBox() {
		return listBox;
	}

}
