package org.jresearch.commons.gwt.client.service;

import java.util.List;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;

import org.fusesource.restygwt.client.DirectRestService;
import org.jresearch.commons.gwt.shared.loader.PageCrudRestLoadConfigBean;
import org.jresearch.commons.gwt.shared.loader.PageLoadResultBean;
import org.jresearch.commons.gwt.shared.model.setting.SettingModel;
import org.jresearch.commons.gwt.shared.service.setting.SettingService;

public interface SettingRestService extends SettingService, DirectRestService {

	@DELETE
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_D)
	@Override
	void remove(List<SettingModel> model);

	@PUT
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_C)
	@Override
	SettingModel create(SettingModel prototype);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_U)
	@Override
	void update(SettingModel model);

	@POST
	@Path(SRV_ROOT + SRV_PATH + M_CRUD_R)
	@Override
	PageLoadResultBean<SettingModel> getAll(PageCrudRestLoadConfigBean<SettingModel> config);

	@GET
	@Path(SRV_ROOT + SRV_PATH + M_R_BY_NAME)
	@Override
	String getValue(String name, String defaultValue);

}
