package org.jresearch.commons.gwt.client.widget;

import java.util.ArrayList;
import java.util.List;

import com.arcbees.chosen.client.ChosenOptions;
import com.arcbees.chosen.client.event.ChosenChangeEvent.ChosenChangeHandler;
import com.arcbees.chosen.client.event.HasChosenChangeHandlers;
import com.arcbees.chosen.client.event.HasHidingDropDownHandlers;
import com.arcbees.chosen.client.event.HidingDropDownEvent.HidingDropDownHandler;
import com.arcbees.chosen.client.gwt.ChosenValueListBox;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gwt.i18n.client.HasDirection.Direction;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.view.client.ProvidesKey;
import com.google.web.bindery.event.shared.HandlerRegistration;

public class ExChosenValueListBox<M> extends ChosenValueListBox<M> implements HasChosenChangeHandlers, HasHidingDropDownHandlers {

	private final ChosenListBoxBinding<M> binding;
	private final Renderer<M> renderer;

	public ExChosenValueListBox(final ChosenListBoxBinding<M> binding, final Renderer<M> renderer) {
		super(renderer);
		this.binding = binding;
		this.renderer = renderer;
		binding.bind(this);
	}

	public ExChosenValueListBox(final ChosenListBoxBinding<M> binding, final Renderer<M> renderer, final ChosenOptions options) {
		super(renderer, options);
		this.binding = binding;
		this.renderer = renderer;
		binding.bind(this);
	}

	public ExChosenValueListBox(final ChosenListBoxBinding<M> binding, final Renderer<M> renderer, final ProvidesKey<M> keyProvider) {
		super(renderer, keyProvider);
		this.binding = binding;
		this.renderer = renderer;
		binding.bind(this);
	}

	public ExChosenValueListBox(final ChosenListBoxBinding<M> binding, final Renderer<M> renderer, final ProvidesKey<M> keyProvider, final ChosenOptions options) {
		super(renderer, keyProvider, options);
		this.binding = binding;
		this.renderer = renderer;
		binding.bind(this);
	}

	@Override
	public HandlerRegistration addChosenChangeHandler(final ChosenChangeHandler handler) {
		return getChosenListBox().addChosenChangeHandler(handler);
	}

	@Override
	public HandlerRegistration addHidingDropDownHandler(final HidingDropDownHandler handler) {
		return getChosenListBox().addHidingDropDownHandler(handler);
	}

	public int getSelectedIndex() {
		return getChosenListBox().getSelectedIndex();
	}

	public void setSelectedIndex(final int index) {
		if (getChosenListBox().getItemCount() >= index) {
			getChosenListBox().setSelectedIndex(index);
		}
	}

	@Override
	public void setValue(final M newValue) {
		if (isAccepted(newValue)) {
			super.setValue(newValue);
		} else {
			binding.setValue(newValue);
		}
	}

	@Override
	public M getValue() {
		final M value = super.getValue();
		return value == null ? binding.getValue() : value;
	}

	public List<M> getAcceptableValues() {
		return values == null ? ImmutableList.<M>of() : new ArrayList<>(values);
	}

	public void addItem(final M value) {
		processValue(value);
		addItemToChosenListBox(value);
		updateChosenListBox();
	}

	public void addItem(final M value, final Direction dir) {
		processValue(value);
		addItemToChosenListBox(value, dir);
		updateChosenListBox();
	}

	public void addItemToGroup(final M value) {
		processValue(value);
		addItemToGroupToChosenListBox(value);
		updateChosenListBox();
	}

	public void addItemToGroup(final M value, final int groupIndex) {
		processValue(value);
		addItemToGroupToChosenListBox(value, groupIndex);
		updateChosenListBox();
	}

	public void addStyledItem(final M value, final String className) {
		processValue(value);
		addStyledItemToChosenListBox(value, className);
		updateChosenListBox();
	}

	public void addStyledItem(final M value, final String className, final int indentLevel) {
		processValue(value);
		addStyledItemToChosenListBox(value, className, indentLevel);
		updateChosenListBox();
	}

	public void addStyledItemToGroup(final M value, final String className, final int groupIndex) {
		processValue(value);
		addStyledItemToGroupToChosenListBox(value, className, groupIndex);
		updateChosenListBox();
	}

	public void addStyledItemToGroup(final M value, final String className, final int indentLevel, final int groupIndex) {
		processValue(value);
		addStyledItemToGroupToChosenListBox(value, className, indentLevel, groupIndex);
		updateChosenListBox();
	}

	private void processValue(final M value) {
		final Object key = keyProvider.getKey(value);
		Preconditions.checkState(!valueKeyToIndex.containsKey(key), "Duplicate value: %s", value);
		valueKeyToIndex.put(key, Integer.valueOf(values.size()));
		values.add(value);
	}

	protected void addItemToChosenListBox(final M value, final Direction dir) {
		getChosenListBox().addItem(renderer.render(value), dir);
	}

	protected void addItemToGroupToChosenListBox(final M value) {
		getChosenListBox().addItemToGroup(renderer.render(value));
	}

	protected void addItemToGroupToChosenListBox(final M value, final int groupIndex) {
		getChosenListBox().addItemToGroup(renderer.render(value), groupIndex);
	}

	protected void addStyledItemToChosenListBox(final M value, final String className) {
		final String toAdd = renderer.render(value);
		getChosenListBox().addStyledItem(toAdd, toAdd, className);
	}

	protected void addStyledItemToChosenListBox(final M value, final String className, final int indentLevel) {
		final String toAdd = renderer.render(value);
		getChosenListBox().addStyledItem(toAdd, toAdd, className, indentLevel);
	}

	protected void addStyledItemToGroupToChosenListBox(final M value, final String className, final int groupIndex) {
		final String toAdd = renderer.render(value);
		getChosenListBox().addStyledItemToGroup(toAdd, toAdd, className, groupIndex);
	}

	protected void addStyledItemToGroupToChosenListBox(final M value, final String className, final int indentLevel, final int groupIndex) {
		final String toAdd = renderer.render(value);
		getChosenListBox().addStyledItemToGroup(toAdd, toAdd, className, indentLevel, groupIndex);
	}

	public void addGroup(final String label) {
		getChosenListBox().addGroup(label);
	}

	public void addGroup(final String label, final String groupId) {
		getChosenListBox().addGroup(label, groupId);
	}

	public void insertGroup(final String label, final int index) {
		getChosenListBox().insertGroup(label, index);
	}

	public void insertGroup(final String label, final String id, final int index) {
		getChosenListBox().insertGroup(label, id, index);
	}

	public void clean() {
		values.clear();
		valueKeyToIndex.clear();
		getChosenListBox().clear(false);
	}

	public void update() {
		updateChosenListBox();
	}

}
