package org.jresearch.commons.gwt.client.widget;

import javax.annotation.Nonnull;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;

import gwt.material.design.client.constants.ButtonType;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.ui.MaterialButton;
import gwt.material.design.client.ui.MaterialModal;
import gwt.material.design.client.ui.MaterialModalContent;
import gwt.material.design.client.ui.MaterialModalFooter;
import gwt.material.design.client.ui.MaterialTitle;

public class ConfirmationBox extends MaterialModal {

    private final MaterialTitle title;
    private final MaterialButton yesButton;
    private final MaterialButton noButton;
    private HandlerRegistration handlerRegistration;

    public ConfirmationBox() {
        yesButton = new MaterialButton(ButtonType.RAISED);
        yesButton.setText("Yes");
        yesButton.setIconType(IconType.DONE);
        yesButton.addClickHandler(this::close);
        yesButton.setBackgroundColor("red");
        noButton = new MaterialButton(ButtonType.RAISED);
        noButton.setText("No");
        noButton.setIconType(IconType.CLEAR);
        noButton.addClickHandler(this::close);
        title = new MaterialTitle();

        final MaterialModalFooter footer = new MaterialModalFooter();
        footer.setGrid(DEBUG_ID_PREFIX);
        footer.add(noButton);
        footer.add(yesButton);

        final MaterialModalContent content = new MaterialModalContent();
        content.add(title);
        content.add(footer);

        add(content);
    }

    public ConfirmationBox(@Nonnull final CloseHandler<MaterialModal> closeHandler) {
        this();
        update(closeHandler);
    }

    public void show(@Nonnull final String titleText, @Nonnull final String descriptionText, @Nonnull final CloseHandler<MaterialModal> closeHandler) {
        show(titleText, descriptionText);
        update(closeHandler);
    }

    public void show(@Nonnull final String titleText, @Nonnull final String descriptionText) {
        title.setTitle(titleText);
        title.setDescription(descriptionText);
        openModal();
    }

    private void update(@Nonnull final CloseHandler<MaterialModal> closeHandler) {
        if (handlerRegistration != null) {
            handlerRegistration.removeHandler();
        }
        handlerRegistration = addCloseHandler(closeHandler);
    }

    private void close(final ClickEvent event) {
        closeModal(noButton == event.getSource());
    }

}
