package org.jresearch.commons.gwt.client.widget;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.google.common.base.MoreObjects;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.Command;

public class Action {

    @Nonnull
    private final SafeHtml actionName;
    @Nullable
    private final Command handler;

    /**
     * @param actionName
     * @param handler
     */
    public Action(@Nonnull final SafeHtml actionName, @Nullable final Command handler) {
        this.actionName = actionName;
        this.handler = handler;
    }

    /**
     * @param actionName
     * @param handler
     */
    public Action(@Nonnull final SafeHtml actionName) {
        this(actionName, null);
    }

    /**
     * @return the actionName
     */
    @Nonnull
    public SafeHtml getActionName() {
        return actionName;
    }

    /**
     * @return the handler
     */
    @Nullable
    public Command getHandler() {
        return handler;
    }

    @SuppressWarnings("nls")
    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .omitNullValues()
                .add("actionName", actionName)
                .add("handler", handler)
                .toString();
    }

}
