package org.jresearch.commons.gwt.client.model.l18n;

import org.jresearch.commons.gwt.client.widget.SimpleL18nComboBox;
import org.jresearch.commons.gwt.shared.model.localization.L18nProperty;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;
import org.jresearch.commons.gwt.shared.model.localization.LocaleTool;

import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Inject;

public class L18nPropertyEditor extends Composite implements LeafValueEditor<L18nProperty> {

	interface L18nPropertyEditorUiBinder extends UiBinder<Widget, L18nPropertyEditor> {
		// nothing
	}

	@UiField(provided = true)
	SimpleL18nComboBox language;
	@UiField
	Label userView;
	@UiField
	TextArea value;
	private L18nProperty property;

	@Inject
	public L18nPropertyEditor(final L18nPropertyEditorUiBinder uiBinder, final SimpleL18nComboBox language) {
		this.language = language;
		initWidget(uiBinder.createAndBindUi(this));
	}

	@UiHandler("language")
	void onLanguageSelection(final SelectionEvent<LocaleModel> event) {
		userView.setText(property.get(event.getSelectedItem()));
		property.getContainer();
		value.setValue(LocaleTool.getRaw(property.getContainer(), event.getSelectedItem()));
	}

	@UiHandler("value")
	void onDescriptionChange(@SuppressWarnings("unused") final ChangeEvent event) {
		property.set(language.getValue(), value.getValue());
	}

	@Override
	public void setValue(final L18nProperty property) {
		this.property = property;
		value.setValue(property.get(language.getValue()));
	}

	@Override
	public L18nProperty getValue() {
		property.set(language.getValue(), value.getValue());
		return property;
	}

}
