package org.jresearch.commons.gwt.client.model.localization;

import org.jresearch.commons.gwt.shared.model.DomainNewModel;

/**
 * Domain model with localized name
 *
 * @author Kot
 *
 */
public class L18nDomainModel<O> extends DomainNewModel<O> {

	private static final long serialVersionUID = -5556548863226293849L;

	private L18nProperty names = new L18nProperty();

	public L18nDomainModel() {
		// default
	}

	public L18nDomainModel(final L18nDomainModel<O> model) {
		super(model);
		names = model.getNames();
	}

	@Override
	public String getName() {
		return names.get();
	}

	@Override
	public void setName(final String name) {
		names.set(name);
	}

	/**
	 * @return the names
	 */
	public L18nProperty getNames() {
		return names;
	}

	/**
	 * @param names
	 *            the names to set
	 */
	public void setNames(final L18nProperty names) {
		this.names = names;
	}

}
