package org.jresearch.commons.gwt.client.model.ref;

import org.jresearch.commons.gwt.shared.model.ref.AttributeValueModel;

public class RefAttributeValueModel extends AttributeValueModel {

	private static final long serialVersionUID = 7463924345408529257L;

	private ValidValueModel value;

	/**
	 * @return the value
	 */
	public ValidValueModel getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(final ValidValueModel value) {
		this.value = value;
	}

	@Override
	public String getStringValue() {
		return getValue().getName();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		final StringBuilder builder = new StringBuilder();
		builder.append("RefAttributeValueModel [getBusinessType()=").append(getBusinessTypeCode()).append(", getStringValue()=").append(getStringValue()).append("]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		return builder.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((getValue() == null) ? 0 : getValue().hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (!(obj instanceof RefAttributeValueModel)) {
			return false;
		}
		final RefAttributeValueModel other = (RefAttributeValueModel) obj;
		if (getValue() == null) {
			if (other.getValue() != null) {
				return false;
			}
		} else if (!getValue().equals(other.getValue())) {
			return false;
		}
		return true;
	}

}
