package org.jresearch.commons.gwt.client.model.localization;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;

/**
 * @author Kot
 *
 */
public class L18nProperty implements Serializable {

    private static final long serialVersionUID = 8592723325042382563L;

    @Nonnull
    private Map<String, LangModel> container;

    public L18nProperty() {
        container = Maps.newHashMap();
    }

    @JsonIgnore
    public String get() {
        return LocaleTool.get(container, true);
    }

    @JsonIgnore
    public void set(final String value) {
        LocaleTool.set(container, value, true);
    }

    public Collection<LangModel> getValues() {
        return LocaleTool.getAll(container);
    }

    public void setValues(final Collection<LangModel> values) {
        LocaleTool.setAll(container, values);
    }

    @JsonIgnore
    public String get(@Nonnull final LocaleModel locale) {
        return LocaleTool.get(container, locale);
    }

    @JsonIgnore
    public void set(@Nonnull final LocaleModel locale, final String value) {
        LocaleTool.set(container, locale, value);
    }

    /**
     * @return the container
     */
    protected Map<String, LangModel> getContainer() {
        return container;
    }

    /**
     * @param container
     *            the container to set
     */
    protected void setContainer(@Nonnull final Map<String, LangModel> container) {
        this.container = container;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        final StringBuilder builder = new StringBuilder();
        builder.append("L18nProperty [get()=").append(get()).append("]"); //$NON-NLS-1$ //$NON-NLS-2$
        return builder.toString();
    }

    public void clear() {
        container.clear();
    }

}
