package org.jresearch.commons.gwt.app.client.mvc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.jresearch.commons.gwt.app.client.model.user.UserProfileModel;
import org.jresearch.commons.gwt.app.client.mvc.widget.UserLinkContainer;
import org.jresearch.commons.gwt.app.client.widget.AboutDialog;
import org.jresearch.commons.gwt.app.client.widget.LoginDialog;
import org.jresearch.commons.gwt.app.client.widget.ResetPasswordDialog;
import org.jresearch.commons.gwt.app.client.widget.SignUpDialog;
import org.jresearch.commons.gwt.client.mvc.event.Bus;

import com.google.gwt.user.client.Command;

@SuppressWarnings("rawtypes")
public abstract class StandartAbstractAppView<C extends AbstractUserAppController> extends AbstractUserAppView<C> {

    @Nullable
    private final LoginDialog loginDialog;
    @Nullable
    private final ResetPasswordDialog resetPasswordDialog;
    @Nullable
    private final SignUpDialog signUpDialog;
    // @Nullable
    // private final ProfileDialog profileDialog;
    @Nullable
    private final AboutDialog aboutDialog;

    public StandartAbstractAppView(@Nonnull final C controller, @Nonnull final UserLinkContainer userLinkContainer, final AboutDialog aboutDialog, final LoginDialog loginDialog, final ResetPasswordDialog resetPasswordDialog, final SignUpDialog signUpDialog, @Nonnull final Bus bus) {
        super(controller, userLinkContainer, bus);
        this.aboutDialog = aboutDialog;
        this.loginDialog = loginDialog;
        this.resetPasswordDialog = resetPasswordDialog;
        this.signUpDialog = signUpDialog;
        // this.profileDialog = profileDialog;
    }

    @Override
    public void showSignUpDialod(final Command command) {
        if (signUpDialog != null) {
            signUpDialog.setCommand(command)
                    .show();
        }
    }

    @Override
    public void showResetPasswordDialog(final Command command) {
        if (resetPasswordDialog != null) {
            resetPasswordDialog.setCommand(command)
                    .show();
        }
    }

    @Override
    public void showAbout() {
        if (aboutDialog != null) {
            aboutDialog.show();
        }
    }

    /**
     * @param command
     *            - Command to execute on login
     */
    @Override
    public void showLoginDialog(final Command command) {
        if (loginDialog != null) {
            loginDialog.setCommand(command)
                    .show();
        }
    }

    @Override
    public void showProfieDialog(final UserProfileModel profileModel) {
        // if (profileDialog != null) {
        // profileDialog.setProfile(profileModel).show();
        // }
    }

}
