package org.jresearch.commons.gwt.app.client.service.user;

import org.jresearch.commons.gwt.app.client.model.user.UserExtModel;
import org.jresearch.commons.gwt.client.service.CrudServiceTools;
import org.jresearch.commons.gwt.shared.loader.GxtCrudLoadConfig;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;

@Singleton
public class UserExtTools {

	private final CrudServiceTools<UserExtModel, UserExtServiceAsync> tool;

	@Inject
	public UserExtTools(final UserExtServiceAsync srv) {
		tool = new CrudServiceTools<>(srv);
	}

	public PagingLoader<GxtCrudLoadConfig<UserExtModel>, PagingLoadResult<UserExtModel>> getLoader() {
		return tool.getLoader();
	}

}
