package org.jresearch.commons.gwt.app.client.service.user;

import org.jresearch.commons.gwt.app.client.model.user.UserModel;
import org.jresearch.commons.gwt.client.service.CrudServiceTools;
import org.jresearch.commons.gwt.shared.loader.GxtCrudLoadConfig;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;

@Singleton
public class UserTools {

	private final CrudServiceTools<UserModel, UserServiceAsync> tool;

	@Inject
	public UserTools(final UserServiceAsync srv) {
		tool = new CrudServiceTools<>(srv);
	}

	public PagingLoader<GxtCrudLoadConfig<UserModel>, PagingLoadResult<UserModel>> getLoader() {
		return tool.getLoader();
	}

}
