package org.jresearch.commons.gwt.app.client.widget;

import org.jresearch.commons.gwt.client.model.localization.L18nProvider;
import org.jresearch.commons.gwt.client.model.localization.L18nStore;
import org.jresearch.commons.gwt.client.model.localization.LocaleModel;
import org.jresearch.commons.gwt.client.model.localization.LocaleTool;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.SetLanguageEvent;
import org.jresearch.commons.gwt.client.widget.SimpleL18nComboBox;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.inject.Inject;

public class LanguageComboBox extends SimpleL18nComboBox {

	@Inject
	public LanguageComboBox(final Bus bus, final L18nStore store, final L18nProvider provider) {
		super(store, provider);
		if (LocaleInfo.getLocaleCookieName() == null && LocaleInfo.getLocaleQueryParam() == null) {
			// if there is no way for us to affect the locale, don't show the
			// selector
			disable();
			hide();
			return;
		}
		String currentLocale = LocaleInfo.getCurrentLocale().getLocaleName();
		if (currentLocale.equals(LocaleModel.DEFAULT_NAME)) {
			currentLocale = LocaleModel.DEFAULT_LANG;
		}
		final String[] localeNames = LocaleInfo.getAvailableLocaleNames();
		if (localeNames.length < 2) {
			// if there is only one language don't show the selector
			disable();
			hide();
			return;
		}
		for (final String localeName : localeNames) {
			if (localeName != LocaleModel.DEFAULT_NAME) {
				final LocaleModel locale = LocaleTool.createLocaleModel(localeName, false);
				getStore().add(locale);
				locale.setDisplayLanguage(LocaleInfo.getLocaleNativeDisplayName(localeName));
				if (localeName.equals(currentLocale)) {
					select(locale);
				}
			}
		}
		addValueChangeHandler(new ValueChangeHandler<LocaleModel>() {
			@Override
			public void onValueChange(final ValueChangeEvent<LocaleModel> event) {
				bus.fire(new SetLanguageEvent(event.getValue()));
			}
		});
	}
}
