package org.jresearch.commons.gwt.app.client.service.mail;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.app.client.model.user.MailTemplateModel;
import org.jresearch.commons.gwt.client.service.CrudServiceTools;
import org.jresearch.commons.gwt.shared.loader.GxtCrudLoadConfig;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;

@Singleton
public class MailTemplateTools {

	private final CrudServiceTools<MailTemplateModel, MailTemplateServiceAsync> tool;

	@Inject
	public MailTemplateTools(@Nonnull final MailTemplateServiceAsync srv) {
		tool = new CrudServiceTools<>(srv);
	}

	public PagingLoader<GxtCrudLoadConfig<MailTemplateModel>, PagingLoadResult<MailTemplateModel>> getLoader() {
		return tool.getLoader();
	}

}
