package org.jresearch.commons.gwt.app.client.widget;

import java.util.List;

import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.REST;
import org.jresearch.commons.gwt.app.client.mvc.event.SignUpEvent;
import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.client.mvc.AbstractMethodCallback;
import org.jresearch.commons.gwt.client.mvc.event.LoginEvent;
import org.jresearch.commons.gwt.flexess.shared.service.FlexessService.ResetStatus;

import com.google.common.collect.Lists;
import com.google.gwt.core.client.Scheduler;
import com.sencha.gxt.widget.core.client.Status;
import com.sencha.gxt.widget.core.client.button.ButtonBar;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;

public class ResetPasswordDialog extends AbstractAuthDialog {

	private TextField email;
	private List<FieldLabel> fields;

	public ResetPasswordDialog() {
		super(AppRs.MSG.resetDialog());
	}

	@Override
	protected void createLinks(final ButtonBar linkBar) {
		linkBar.add(createEventLink(AppRs.MSG.existingUser(), new LoginEvent()));
		signUp = createEventLink(AppRs.MSG.register(), new SignUpEvent());
		linkBar.add(signUp);
		signUp.disable();
	}

	@Override
	protected List<FieldLabel> getFields() {
		if (fields == null) {
			fields = Lists.newArrayList();

			email = new TextField();
			fields.add(new FieldLabel(email, AppRs.MSG.emailField()));
		}

		return fields;
	}

	@Override
	protected String getActionName() {
		return AppRs.MSG.resetAction();
	}

	@Override
	protected void doAction(final Status status) {
		final String value = email.getValue();
		if (value != null) {
			REST.withCallback(new AbstractMethodCallback<ResetStatus>(bus) {
				@SuppressWarnings("incomplete-switch")
				@Override
				public void onSuccess(final Method method, final ResetStatus result) {
					switch (result) {
					case Done:
						ResetPasswordDialog.this.hide();
						if (command != null) {
							Scheduler.get().scheduleDeferred(command);
						}
						break;
					case Disable:
						status.clearStatus(AppRs.MSG.resetNotPossible());
						getButtonBar().enable();
						break;
					case NotFound:
						status.clearStatus(AppRs.MSG.emailNotFound());
						getButtonBar().enable();
						break;
					}
				}
			}).call(service).reset(value);
		}
	}

	@Override
	protected void resetFields() {
		email.reset();
	}

}
