package org.jresearch.commons.gwt.app.client.widget;

import java.util.ArrayList;
import java.util.List;

import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.REST;
import org.jresearch.commons.gwt.app.client.mvc.event.ResetPasswordEvent;
import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.client.mvc.AbstractMethodCallback;
import org.jresearch.commons.gwt.client.mvc.event.LoginEvent;
import org.jresearch.commons.gwt.flexess.shared.service.FlexessService.SignUpStatus;

import com.google.common.collect.Lists;
import com.google.gwt.core.client.Scheduler;
import com.sencha.gxt.widget.core.client.Status;
import com.sencha.gxt.widget.core.client.button.ButtonBar;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.TextField;

public class SignUpDialog extends AbstractAuthDialog {

	private TextField email;
	private ArrayList<FieldLabel> fields;

	public SignUpDialog() {
		super(AppRs.MSG.registerDialog());
	}

	@Override
	protected void createLinks(final ButtonBar linkBar) {
		linkBar.add(createEventLink(AppRs.MSG.existingUser(), new LoginEvent()));
		reset = createEventLink(AppRs.MSG.resetPassword(), new ResetPasswordEvent());
		linkBar.add(reset);
		reset.disable();
	}

	@Override
	protected List<FieldLabel> getFields() {
		if (fields == null) {
			fields = Lists.newArrayList();

			email = new TextField();
			fields.add(new FieldLabel(email, AppRs.MSG.emailField()));
		}

		return fields;
	}

	@Override
	protected String getActionName() {
		return AppRs.MSG.registerAction();
	}

	@Override
	protected void doAction(final Status status) {
		final String value = email.getValue();
		if (value != null) {
			REST.withCallback(new AbstractMethodCallback<SignUpStatus>(bus) {
				@SuppressWarnings("incomplete-switch")
				@Override
				public void onSuccess(final Method method, final SignUpStatus result) {
					switch (result) {
					case Done:
						SignUpDialog.this.hide();
						if (command != null) {
							Scheduler.get().scheduleDeferred(command);
						}
						break;
					case Disable:
						status.clearStatus(AppRs.MSG.registrationNotPossible());
						getButtonBar().enable();
						break;
					case Exist:
						status.clearStatus(AppRs.MSG.userExists());
						getButtonBar().enable();
						break;
					}
				}
			}).call(service).signUp(value);
		}
	}

	@Override
	protected void resetFields() {
		email.reset();
	}

}
