package org.jresearch.commons.gwt.app.client.module;

import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.ErrorEvent;

import com.google.gwt.user.client.Command;
import com.sencha.gxt.data.shared.loader.LoadExceptionEvent;
import com.sencha.gxt.data.shared.loader.LoadExceptionEvent.LoadExceptionHandler;

public class AppLoadExceptionHandler<C> implements LoadExceptionHandler<C> {

	private Bus bus;

	public AppLoadExceptionHandler(Bus bus) {
		this.bus = bus;
	}

	@Override
	public void onLoadException(final LoadExceptionEvent<C> le) {
		bus.fire(new ErrorEvent(le.getException(), new Command() {
			@Override
			public void execute() {
				le.getSource().load();
			}
		}));
	}

}
