package org.jresearch.commons.gwt.app.client.widget;

import java.util.List;

import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.client.mvc.AbstractCallback;
import org.jresearch.commons.gwt.client.mvc.event.Bus;
import org.jresearch.commons.gwt.client.mvc.event.ICommandEvent;
import org.jresearch.commons.gwt.flexess.client.service.FlexessServiceAsync;

import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.user.client.Command;
import com.google.inject.Inject;
import com.google.web.bindery.event.shared.Event;
import com.sencha.gxt.widget.core.client.Component;
import com.sencha.gxt.widget.core.client.Dialog;
import com.sencha.gxt.widget.core.client.Status;
import com.sencha.gxt.widget.core.client.WidgetComponent;
import com.sencha.gxt.widget.core.client.button.ButtonBar;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent.SelectHandler;
import com.sencha.gxt.widget.core.client.form.FieldLabel;

public abstract class AbstractAuthDialog extends Dialog implements ICommandWidget<Dialog> {

    private TextButton cancel;
    private TextButton action;
    private Status status;
    protected Command command;
    protected Component signUp;
    protected Component reset;
    private boolean initProcessed = false;

    @Inject
    protected FlexessServiceAsync service;
    @Inject
    protected Bus bus;
    private ButtonBar socialBar;
    private final VerticalLayoutContainer main;

    protected AbstractAuthDialog(final String heading) {
        setPredefinedButtons();
        main = new VerticalLayoutContainer();
        final VerticalLayoutContainer formPanel = new VerticalLayoutContainer();
        setModal(true);
        setBodyBorder(true);
        setWidth(400);
        setResizable(true);
        setHeadingHtml(heading);

        final List<FieldLabel> fields = getFields();

        if (!fields.isEmpty()) {
            for (final FieldLabel field : fields) {
                formPanel.add(field);
            }
            setFocusWidget(fields.get(0));
        }
        main.add(createSocialButtons());
        main.add(formPanel);
        main.add(createLinksButtons());
        main.add(createStatus());
        add(main, new MarginData(10));
    }

    protected ButtonBar createSocialButtons() {
        socialBar = new ButtonBar();
        socialBar.setPack(BoxLayoutPack.CENTER);
        socialBar.setSpacing(20);
        createSocialLoginButtons(socialBar);
        return socialBar;
    }

    protected ButtonBar createLinksButtons() {
        final ButtonBar linkBar = new ButtonBar();
        linkBar.setPack(BoxLayoutPack.CENTER);
        linkBar.addStyleName("j-dialog-link-bar"); //$NON-NLS-1$
        linkBar.setSpacing(20);
        createLinks(linkBar);
        return linkBar;
    }

    protected Status createStatus() {
        if (status == null) {
            status = new Status();
        }
        return status;
    }

    @Override
    protected void onHide() {
        reset();
        super.onHide();
    }

    @Override
    protected void onAttach() {
        if (reset != null) {
            service.isResetEnable(new AbstractCallback<Boolean>(bus) {
                @Override
                public void onSuccess(final Boolean result) {
                    if (result != null && result.booleanValue()) {
                        reset.enable();
                    }
                }
            });
        }
        if (signUp != null) {
            service.isSignUpEnable(new AbstractCallback<Boolean>(bus) {
                @Override
                public void onSuccess(final Boolean result) {
                    if (result != null && result.booleanValue()) {
                        signUp.enable();
                    }
                }
            });
        }
        // due to injection - do not use the injected fields in constructor
        if (!initProcessed) {
            init();
            initProcessed = true;
        }
        super.onAttach();
    }

    abstract protected List<FieldLabel> getFields();

    abstract protected String getActionName();

    abstract protected void doAction(Status actionStatus);

    /**
     * some action after all things are injected
     */
    protected void init() {
        // do nothing in base class
    }

    /**
     * @param linkBar
     *            button bar to add the links
     */
    protected void createLinks(final ButtonBar linkBar) {
        // do nothing in base class
    }

    /**
     * @param bar
     *            button bar to add the social buttons
     */
    protected void createSocialLoginButtons(final ButtonBar bar) {
        // do nothing in base class
    }

    @Override
    protected void onKeyPress(final com.google.gwt.user.client.Event event) {
        super.onKeyPress(event);
        final int keyCode = event.getKeyCode();
        if (keyCode == KeyCodes.KEY_ENTER && action.isEnabled()) {
            onSubmit();
        }
    }

    @Override
    protected void createButtons() {
        getButtonBar().clear();
        if (action == null) {
            action = createButton(getActionName());
            action.addSelectHandler(new SelectHandler() {
                @Override
                public void onSelect(final SelectEvent event) {
                    onSubmit();
                }
            });
        }
        addButton(action);
        if (cancel == null) {
            cancel = createButton(AppRs.MSG.cancelButton());
            cancel.addSelectHandler(new SelectHandler() {
                @Override
                public void onSelect(final SelectEvent event) {
                    onCancel();
                }
            });
        }
        addButton(cancel);
    }

    protected void onCancel() {
        hide();
    }

    protected void reset() {
        resetFields();
        status.clearStatus(""); //$NON-NLS-1$
        getButtonBar().enable();
        socialBar.enable();
    }

    protected abstract void resetFields();

    protected void onSubmit() {
        status.setBusy(AppRs.MSG.pleaseWait());
        getButtonBar().disable();
        socialBar.disable();
        doAction(status);
    }

    protected <E extends Event<?> & ICommandEvent> Component createEventLink(final String link, final E event) {
        // TODO Stas new appear (just a line)!
        final TextButton button = new TextButton(link, new SelectHandler() {
            @Override
            public void onSelect(final SelectEvent e) {
                AbstractAuthDialog.this.hide();
                event.setCommand(command);
                bus.fire(event);
            }
        });
        return new WidgetComponent(button);
    }

    @SuppressWarnings("static-method")
    protected TextButton createButton(final String text) {
        return new TextButton(text);
    }

    /**
     * @param command
     *            - command to forward after successful login, <code>null</code>
     *            to skip
     */
    @Override
    public Dialog setCommand(final Command command) {
        this.command = command;
        return this;
    }

    protected ButtonBar getSocialBar() {
        return socialBar;
    }

}
