package org.jresearch.commons.gwt.app.client.widget;

import java.util.ArrayList;
import java.util.List;

import org.jresearch.commons.gwt.app.client.resource.AppRs;
import org.jresearch.commons.gwt.client.service.about.AboutTools;
import org.jresearch.commons.gwt.shared.loader.GxtLoadConfig;
import org.jresearch.commons.gwt.shared.loader.LoadConfig;
import org.jresearch.commons.gwt.shared.model.about.AboutModel;

import com.google.gwt.resources.client.ImageResource;
import com.google.inject.Inject;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;
import com.sencha.gxt.widget.core.client.Component;
import com.sencha.gxt.widget.core.client.Dialog;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;

public class AboutDialog extends Dialog {

	private final ListStore<AboutModel> store;

	@Inject
	public AboutDialog(final AboutTools aboutTools) {
		this(null, null, aboutTools);
	}

	@SuppressWarnings("unused")
	public AboutDialog(final ImageResource logo, final Component content, final AboutTools aboutTools) {

		setHeadingHtml(AppRs.MSG.aboutDialog());
		setModal(true);
		setResizable(true);
		setPixelSize(700, 350);
		setOnEsc(true);

		final PagingLoader<GxtLoadConfig<LoadConfig>, PagingLoadResult<AboutModel>> loader = aboutTools.getLoader();
		store = new ListStore<AboutModel>(new ModelKeyProvider<AboutModel>() {
			@Override
			public String getKey(final AboutModel item) {
				return item.getModuleName();
			}
		});
		loader.addLoadHandler(new LoadResultListStoreBinding<GxtLoadConfig<LoadConfig>, AboutModel, PagingLoadResult<AboutModel>>(store));
		loader.load();
		final Grid<AboutModel> versionGrid = new Grid<AboutModel>(store, createAboutColumnModel());
		// versionGrid.setAutoExpandColumn(AboutModel.Id.moduleName.name());
		// versionGrid.setColumnLines(true);
		// versionGrid.setStripeRows(true);
		add(versionGrid);
	}

	@SuppressWarnings("unused")
	private ColumnModel<AboutModel> createAboutColumnModel() {
		final List<ColumnConfig<AboutModel, ?>> configs = new ArrayList<ColumnConfig<AboutModel, ?>>();
		configs.add(new ColumnConfig<AboutModel, String>(new AboutValueProvider(AppRs.MSG.module()) {
			@Override
			public String getValue(final AboutModel object) {
				return object.getModuleName();
			}
		}, 100, AppRs.MSG.module()));
		configs.add(new ColumnConfig<AboutModel, String>(new AboutValueProvider(AppRs.MSG.version()) {
			@Override
			public String getValue(final AboutModel object) {
				return object.getModuleVersion();
			}
		}, 120, AppRs.MSG.version()));
		configs.add(new ColumnConfig<AboutModel, String>(new AboutValueProvider(AppRs.MSG.buildNumber()) {
			@Override
			public String getValue(final AboutModel object) {
				return object.getBuildNum();
			}
		}, 80, AppRs.MSG.buildNumber()));
		configs.add(new ColumnConfig<AboutModel, String>(new AboutValueProvider(AppRs.MSG.buildAt()) {
			@Override
			public String getValue(final AboutModel object) {
				return object.getBuildDate();
			}
		}, 100, AppRs.MSG.buildAt()));
		configs.add(new ColumnConfig<AboutModel, String>(new AboutValueProvider(AppRs.MSG.buildOn()) {
			@Override
			public String getValue(final AboutModel object) {
				return object.getBuildServer();
			}
		}, 300, AppRs.MSG.buildOn()));
		return new ColumnModel<AboutModel>(configs);
	}

	abstract class AboutValueProvider implements ValueProvider<AboutModel, String> {

		private final String path;

		public AboutValueProvider(final String path) {
			this.path = path;
		}

		@Override
		public void setValue(final AboutModel object, final String value) {
			throw new IllegalStateException();
		}

		@Override
		public String getPath() {
			return path;
		}

	}

}
