package org.jresearch.commons.gwt.client.service;

import java.util.List;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.shared.loader.GxtLoadConfig;
import org.jresearch.commons.gwt.shared.loader.LoadConfig;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoadResultBean;

/** Helper class to create data loader by remote service */
public abstract class CustomServiceTools<SC extends LoadConfig, C extends GxtLoadConfig<SC>, M, S extends IReadDomainServiceAsync<SC, M>> extends CustomTools<C, M> {

	@Nonnull private final S service;

	public CustomServiceTools(@Nonnull final S service) {
		assert service != null;
		this.service = service;
	}

	@Override
	public void customLoad(final C loadConfig, final AsyncCallback<PagingLoadResult<M>> callback) {
		getService().getAll(loadConfig.asLoadConfig(), new AsyncCallback<List<M>>() {
			@Override
			public void onFailure(final Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onSuccess(final List<M> result) {
				callback.onSuccess(new PagingLoadResultBean<>(result, result.size(), 0));
			}
		});
	}

	@Nonnull
	public S getService() {
		return service;
	}

}
