package org.jresearch.commons.gwt.client.service;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.jresearch.commons.gwt.shared.tools.Strings;

import com.sencha.gxt.data.shared.loader.BeforeLoadEvent;
import com.sencha.gxt.data.shared.loader.LoadEvent;
import com.sencha.gxt.data.shared.loader.LoadExceptionEvent;
import com.sencha.gxt.data.shared.loader.LoaderHandler;

public class ReentrantLoadPreventListener<C, M> implements LoaderHandler<C, M> {

	private static Logger LOGGER = Logger.getLogger("org.jresearch.commons.gwt.client.service.CustomTools"); //$NON-NLS-1$

	private boolean loading = false;

	@Override
	public void onBeforeLoad(final BeforeLoadEvent<C> le) {
		le.getLoadConfig();
		if (loading) {
			le.setCancelled(true);
			if (LOGGER.isLoggable(Level.INFO)) {
				LOGGER.log(Level.INFO, Strings.format("Double loading - canceled {0}", le.getLoadConfig())); //$NON-NLS-1$
			}
		} else {
			loading = true;
			if (LOGGER.isLoggable(Level.FINER)) {
				LOGGER.log(Level.FINER, Strings.format("Loading... {0}", le.getLoadConfig())); //$NON-NLS-1$
			}
		}
	}

	@Override
	public void onLoadException(final LoadExceptionEvent<C> event) {
		loading = false;
	}

	@Override
	public void onLoad(final LoadEvent<C, M> event) {
		loading = false;
	}

}
