package org.jresearch.commons.gwt.client.service.setting;

import org.jresearch.commons.gwt.client.model.setting.SettingModel;
import org.jresearch.commons.gwt.client.service.ServiceTools;
import org.jresearch.commons.gwt.shared.loader.GxtLoadConfig;
import org.jresearch.commons.gwt.shared.loader.LoadConfig;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;

@Singleton
public class SettingTools {

	private final ServiceTools<SettingModel, SettingServiceAsync> tool;

	@SuppressWarnings("unused")
	@Inject
	public SettingTools(final SettingServiceAsync srv) {
		tool = new ServiceTools<SettingModel, SettingServiceAsync>(srv);
	}

	public PagingLoader<GxtLoadConfig<LoadConfig>, PagingLoadResult<SettingModel>> getLoader() {
		return tool.getLoader();
	}

}
