package org.jresearch.commons.gwt.client.model.localization;

import org.jresearch.commons.gwt.client.model.ValueProvider;
import org.jresearch.commons.gwt.client.resource.UtilsRs;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

public class GwtL18nValueProvider<T> implements ValueProvider<T, String> {

    private LocaleModel locale;
    private final ValueProvider<T, L18nProperty> provider;

    public GwtL18nValueProvider(final ValueProvider<T, L18nProperty> provider) {
        this.provider = provider;
        locale = LocaleTool.getCurrentLocale(true);
    }

    @Override
    public String getValue(final T object) {
        final L18nProperty property = provider.getValue(object);
        return UtilsRs.TXT.l18nAdminValue(LocaleTool.getRaw(property.getContainer(), locale), property.get(locale));
    }

    @Override
    public String getPath() {
        return provider.getPath();
    }

    /**
     * @param locale the locale to set
     */
    public void setLocale(final LocaleModel locale) {
        this.locale = locale;
    }

}
