package org.jresearch.commons.gwt.client.model.localization;

import java.util.List;

import org.jresearch.commons.gwt.client.service.localization.ILocalizationServiceAsync;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sencha.gxt.data.client.loader.RpcProxy;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.ListLoadResultBean;
import com.sencha.gxt.data.shared.loader.ListLoader;
import com.sencha.gxt.data.shared.loader.LoadResultListStoreBinding;

@Singleton
public class L18nStoreWithLoader extends L18nStore {

	private final ListLoader<ListLoadConfig, ListLoadResult<LocaleModel>> loader;

	@Inject
	public L18nStoreWithLoader(final ILocalizationServiceAsync service) {
		final RpcProxy<ListLoadConfig, ListLoadResult<LocaleModel>> proxy = new RpcProxy<ListLoadConfig, ListLoadResult<LocaleModel>>() {
			@Override
			public void load(final ListLoadConfig loadConfig, final AsyncCallback<ListLoadResult<LocaleModel>> callback) {
				service.getLanguages(new AsyncCallback<List<LocaleModel>>() {
					@Override
					public void onFailure(final Throwable caught) {
						callback.onFailure(caught);
					}

					@Override
					public void onSuccess(final List<LocaleModel> result) {
						callback.onSuccess(new ListLoadResultBean<>(result));
					}
				});
			}
		};
		loader = new ListLoader<>(proxy);
		loader.addLoadHandler(new LoadResultListStoreBinding<ListLoadConfig, LocaleModel, ListLoadResult<LocaleModel>>(this));
	}

	public ListLoader<ListLoadConfig, ListLoadResult<LocaleModel>> getLoader() {
		return loader;
	}

}
