package org.jresearch.commons.gwt.client.service;

import javax.annotation.Nonnull;

import org.jresearch.commons.gwt.shared.loader.CrudLoadConfig;
import org.jresearch.commons.gwt.shared.loader.CrudLoadConfigBean;
import org.jresearch.commons.gwt.shared.loader.GxtCrudLoadConfig;
import org.jresearch.commons.gwt.shared.loader.GxtCrudLoadConfigBean;
import org.jresearch.commons.gwt.shared.model.IDomainNewModel;

/** Helper class to create data loader by remote service */
public class CrudServiceTools<M extends IDomainNewModel<?>, S extends IReadDomainServiceAsync<CrudLoadConfig<M>, M>> extends CustomServiceTools<CrudLoadConfig<M>, GxtCrudLoadConfig<M>, M, S> {

	public CrudServiceTools(@Nonnull final S service) {
		super(service);
	}

	@Override
	protected GxtCrudLoadConfig<M> createLoadConfig() {
		return new GxtCrudLoadConfigBean<>(new CrudLoadConfigBean<M>());
	}

}
