package org.jresearch.commons.gwt.client.widget;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.jresearch.commons.gwt.client.model.localization.L18nProvider;
import org.jresearch.commons.gwt.client.model.localization.L18nStoreWithLoader;
import org.jresearch.commons.gwt.shared.model.localization.LocaleModel;
import org.jresearch.commons.gwt.shared.tools.Strings;

import com.google.inject.Inject;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell.TriggerAction;
import com.sencha.gxt.data.shared.loader.ListLoadConfig;
import com.sencha.gxt.data.shared.loader.ListLoadResult;
import com.sencha.gxt.data.shared.loader.LoadEvent;
import com.sencha.gxt.data.shared.loader.LoadHandler;

public class L18nComboBox extends SimpleL18nComboBox {

	private static Logger logger = Logger.getLogger("org.jresearch.commons.gwt.app.client.widget.LocalizationComboBox"); //$NON-NLS-1$
	private final L18nStoreWithLoader store;

	@Inject
	public L18nComboBox(final L18nStoreWithLoader store, final L18nProvider provider) {
		super(store, provider);
		this.store = store;
		// Set selection on load
		if (store.getLoader() != null) {
			store.getLoader().addLoadHandler(new LoadHandler<ListLoadConfig, ListLoadResult<LocaleModel>>() {
				@Override
				public void onLoad(final LoadEvent<ListLoadConfig, ListLoadResult<LocaleModel>> event) {
					setSelection();
				}
			});
		}
		setAllowBlank(false);
		setTriggerAction(TriggerAction.ALL);
		setEditable(false);
	}

	@Override
	protected void onAttach() {
		super.onAttach();
		if (store.getAll().isEmpty()) {
			store.getLoader().load();
		} else {
			setSelection();
		}
	}

	protected void setSelection() {
		if (getValue() == null) {
			final LocaleModel en = store.findModelWithKey("en"); //$NON-NLS-1$
			logger.log(Level.FINE, Strings.format("Found locale {0}", en)); //$NON-NLS-1$
			setValue(en, false);
			store.addTopLocale(en);
			getStore().applySort(false);
		}
	}
}
