package org.jresearch.commons.gwt.shared.loader;

import java.util.List;

import com.sencha.gxt.data.shared.SortInfo;
import com.sencha.gxt.data.shared.loader.PagingLoadConfig;
import com.sencha.gxt.data.shared.loader.PagingLoadConfigBean;

public class GxtLoadConfigBean<C extends LoadConfig> implements GxtLoadConfig<C> {

	private static final long serialVersionUID = 4512644583685508590L;

	private final C jrsConfig;
	private final PagingLoadConfig gxtConfig;

	public GxtLoadConfigBean(final C jrsConfig) {
		this.jrsConfig = jrsConfig;
		gxtConfig = new PagingLoadConfigBean();
	}

	/**
	 * @param limit
	 * @see com.sencha.gxt.data.shared.loader.PagingLoadConfig#setLimit(int)
	 */
	@Override
	public void setLimit(final int limit) {
		gxtConfig.setLimit(limit);
	}

	/**
	 * @return
	 * @see com.sencha.gxt.data.shared.loader.ListLoadConfig#getSortInfo()
	 */
	@Override
	public List<? extends SortInfo> getSortInfo() {
		return gxtConfig.getSortInfo();
	}

	/**
	 * @param offset
	 * @see com.sencha.gxt.data.shared.loader.PagingLoadConfig#setOffset(int)
	 */
	@Override
	public void setOffset(final int offset) {
		gxtConfig.setOffset(offset);
	}

	/**
	 * @param info
	 * @see com.sencha.gxt.data.shared.loader.ListLoadConfig#setSortInfo(java.util.List)
	 */
	@Override
	public void setSortInfo(final List<? extends SortInfo> info) {
		gxtConfig.setSortInfo(info);
	}

	/**
	 * @return
	 * @see com.sencha.gxt.data.shared.loader.PagingLoadConfig#getLimit()
	 */
	@Override
	public int getLimit() {
		return gxtConfig.getLimit();
	}

	/**
	 * @return
	 * @see com.sencha.gxt.data.shared.loader.PagingLoadConfig#getOffset()
	 */
	@Override
	public int getOffset() {
		return gxtConfig.getOffset();
	}

	@Override
	public C asLoadConfig() {
		return jrsConfig;
	}

}
