package org.jresearch.commons.gwt.client.service.ref;

import org.jresearch.commons.gwt.client.service.ServiceTools;
import org.jresearch.commons.gwt.shared.loader.GxtLoadConfig;
import org.jresearch.commons.gwt.shared.loader.LoadConfig;
import org.jresearch.commons.gwt.shared.model.ref.BusinessTypeModel;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;

@Singleton
public class RefTools {

	private final ServiceTools<BusinessTypeModel, RefServiceAsync> tool;

	@SuppressWarnings("unused")
	@Inject
	public RefTools(final RefServiceAsync srv) {
		tool = new ServiceTools<BusinessTypeModel, RefServiceAsync>(srv);
	}

	public PagingLoader<GxtLoadConfig<LoadConfig>, PagingLoadResult<BusinessTypeModel>> getLoader() {
		return tool.getLoader();
	}

}
