package org.jresearch.commons.gwt.client.model;

import org.jresearch.commons.gwt.shared.model.DomainNewModel;

import com.sencha.gxt.data.shared.Converter;
import com.sencha.gxt.data.shared.Store;

public class DomainIdConverter<M extends DomainNewModel<String>> implements Converter<String, M> {

	private final Store<M> store;

	public DomainIdConverter(final Store<M> store) {
		this.store = store;
	}

	@Override
	public String convertFieldValue(final M model) {
		return model.getId();
	}

	@Override
	public M convertModelValue(final String id) {
		return store.findModelWithKey(id);
	}
}