package org.jresearch.commons.gwt.client.service;

import javax.annotation.Nonnull;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sencha.gxt.data.shared.loader.PagingLoadConfig;
import com.sencha.gxt.data.shared.loader.PagingLoadResult;
import com.sencha.gxt.data.shared.loader.PagingLoader;

/** Helper class to create data loader by remote service */
public abstract class CustomTools<C extends PagingLoadConfig, M> {

	@SuppressWarnings("unused")
	@Nonnull
	public PagingLoader<C, PagingLoadResult<M>> getLoader(final C config) {
		final PagingLoader<C, PagingLoadResult<M>> loader = new PagingLoader<C, PagingLoadResult<M>>(new ServiceRpcProxy<C, M>(this)) {
			@Override
			protected C newLoadConfig() {
				return createLoadConfig();
			}
		};
		loader.setRemoteSort(true);
		loader.addLoaderHandler(new ReentrantLoadPreventListener<C, PagingLoadResult<M>>());
		if (config != null) {
			loader.useLoadConfig(config);
		}
		return loader;
	}

	abstract protected C createLoadConfig();

	@SuppressWarnings("null")
	public PagingLoader<C, PagingLoadResult<M>> getLoader() {
		return getLoader((C) null);
	}

	public abstract void customLoad(C loadConfig, AsyncCallback<PagingLoadResult<M>> callback);

}
