package org.jresearch.commons.gwt.client.service;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.jresearch.commons.gwt.client.resource.UtilsRs;

import com.sencha.gxt.data.shared.loader.BeforeLoadEvent;
import com.sencha.gxt.data.shared.loader.LoadEvent;
import com.sencha.gxt.data.shared.loader.LoadExceptionEvent;
import com.sencha.gxt.data.shared.loader.LoaderHandler;

public class ReentrantLoadPreventListener<C, M> implements LoaderHandler<C, M> {

	private static Logger LOGGER = Logger.getLogger("org.jresearch.commons.gwt.shared.service.CustomTools"); //$NON-NLS-1$

	private boolean loading = false;

	@Override
	public void onBeforeLoad(final BeforeLoadEvent<C> le) {
		le.getLoadConfig();
		if (loading) {
			le.setCancelled(true);
			if (LOGGER.isLoggable(Level.INFO)) {
				LOGGER.log(Level.INFO, UtilsRs.FMT.doubleLoading(le.getLoadConfig()));
			}
		} else {
			loading = true;
			if (LOGGER.isLoggable(Level.FINER)) {
				LOGGER.log(Level.FINER, UtilsRs.FMT.loading(le.getLoadConfig()));
			}
		}
	}

	@Override
	public void onLoadException(final LoadExceptionEvent<C> event) {
		loading = false;
	}

	@Override
	public void onLoad(final LoadEvent<C, M> event) {
		loading = false;
	}

}
